/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.options;

import javafx.scene.Node;
import javafx.scene.control.TabPane;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.scenes.options.OptionsTab;

public class OptionsScene
extends AbstractScene
implements SceneSupportUserBlock {
    private OptionsTab optionsTab;
    private UserBlock userBlock;

    public OptionsScene(JavaFXApplication application) {
        super("scenes/options/options.fxml", application);
    }

    @Override
    protected void doInit() {
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor());
        this.optionsTab = new OptionsTab(this.application, (TabPane)LookupHelper.lookup((Node)this.layout, "#tabPane"));
    }

    @Override
    public void reset() {
        ClientProfile profile = this.application.profilesService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#savepanel", "#save").ifPresent(saveButton -> saveButton.setOnAction(e -> {
            try {
                this.application.profilesService.setOptionalView(profile, this.optionsTab.getOptionalView());
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        LookupHelper.lookupIfPossible((Node)this.layout, "#savepanel", "#clientSettings").ifPresent(resetButton -> resetButton.setOnAction(e -> {
            this.optionsTab.clear();
            this.application.profilesService.setOptionalView(profile, new OptionalView(profile));
            this.optionsTab.addProfileOptionals(this.application.profilesService.getOptionalView());
        }));
        this.optionsTab.clear();
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(x -> x.setOnAction(e -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.optionsTab.addProfileOptionals(this.application.profilesService.getOptionalView());
        this.userBlock.reset();
    }

    @Override
    public String getName() {
        return "options";
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }
}

